<%@ Application Language="C#" %>
<script RunAt="server">
    
    /// <summary>
    /// Notification thread declaration
    /// </summary>
    System.Threading.Thread notifyThread;

    /// <summary>
    /// At application startup:
    /// 1. Initialize the servername, config username and password
    /// 2. Start the notification thread 
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    void Application_Start(object sender, EventArgs e)
    {
        //Initialize the servername, config username and password
        eI.SWQA.RWCEC.General.InitializeRootConfig();

        //start the notification thread 
        notifyThread = new System.Threading.Thread(new System.Threading.ThreadStart(eI.SWQA.RWCEC.Notification.Start));
        notifyThread.Start();
    }

    protected void Application_BeginRequest(object sender, EventArgs e)
    {
        HttpContext.Current.Request.ContentEncoding = Encoding.GetEncoding(eI.SWQA.RWCEC.General.HTTPEncoding);
        HttpContext.Current.Response.ContentEncoding = Encoding.GetEncoding(eI.SWQA.RWCEC.General.HTTPEncoding);
    }

    /// <summary>
    /// Allow access to ExchangeNotification.aspx file
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    void Application_AuthenticateRequest(object sender, EventArgs e)
    {
        // Bypass Authentication user to access ExchangeNotification.aspx page
        if (null == User || !User.Identity.IsAuthenticated)
        {
            string page = Request.Url.Segments.Last();
            if ("ExchangeNotification.aspx".Equals(page, StringComparison.InvariantCultureIgnoreCase))
            {
                HttpContext.Current.User = new System.Security.Principal.GenericPrincipal(new System.Security.Principal.GenericIdentity(""), null);
                FormsAuthentication.SetAuthCookie(HttpContext.Current.User.Identity.Name, false);
            }
        }
    }

    /// <summary>
    /// At the applciation end:
    /// 1. Stop the subscription renew timer
    /// 2. Unsubscribe all the subscribed users
    /// 3. Kill the notification thread
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    void Application_End(object sender, EventArgs e)
    {
        //Stop the timer
        eI.SWQA.RWCEC.Notification.SubscriptionRenewTimer.Stop();
        eI.SWQA.RWCEC.Notification.SubscriptionRenewTimer.Dispose();

        //Unsubscribe all the subscribed users
        eI.SWQA.RWCEC.Notification.UnSubscribe();

        //Kill the thread 
        notifyThread.Abort();
    }

    void Application_Error(object sender, EventArgs e)
    {
        // Code that runs when an unhandled error occurs
    }

    void Session_Start(object sender, EventArgs e)
    {
        // Code that runs when a new session is started
    }

    void Session_End(object sender, EventArgs e)
    {
        // Code that runs when a session ends. 
        // Note: The Session_End event is raised only when the sessionstate mode
        // is set to InProc in the Web.config file. If session mode is set to StateServer 
        // or SQLServer, the event is not raised.
    }
       
</script>
